# Q Code Transformation Command-line Interface

This is a command-line interface (CLI) to orchestrate Q Developer APIs for Q Code Transformation.

This interacts with the same Q Developer APIs used in IntelliJ and VSCode IDE plugins via a custom `boto3` client.

The Public Preview implementation uses bearer token auth obtained via AWS IAM Identity Center (IdC) for OpenID Client (OIDC). The GA version will not support AWS Sigv4 Auth via IAM credentials.

Amazon Q performs transformations based on your project's requests, descriptions, and content. To maintain security, avoid including external, unvetted artifacts in your project repository and always validate transformed code for both functionality and security.

## Pre-requisites

The CLI depends on the following applications present in the machine to run correctly.

1. Maven (>=3.8) - verify installation by running `which mvn`
2. Git - verify installation by running `which git`
3. JDK 8/11/17/21 (for pre-transformation) and 17/21 (for post-transformation)
4. AWS credentials profile to use for IAM authentication ([setup document](https://docs.aws.amazon.com/cli/v1/userguide/cli-authentication-short-term.html)).

The standalone binary runs in a virtual environment and installs its required dependencies (`boto3`, `defusedxml`, `pyyaml`, and `requests`).

## Installation Instructions

1. Download and extract `amzn_qct_cli-1.1.0.zip`.
 * `unzip amzn_qct_cli-1.1.0.zip -d <path/to/unzip/dir/>`
2. Verify python version >= 3.12.
 * `python --version`
3. Go to your preferred directory to install qct.
 * `cd <your-preferred-directory>`
4. Create a virtual environment (venv).
 * `python -m venv qct-cli`
5. Activate the virtual environment.
 * `source qct-cli/bin/activate`
6. Install the package binary based on your machine architecture
 * `pip3 install <path/to/unzip/dir>/Linux_aarch64/amzn_qct_cli-1.1.0-py3-none-any.whl`
 * `pip3 install <path/to/unzip/dir>/Linux_x86_64/amzn_qct_cli-1.1.0-py3-none-any.whl`
 * Note: `Linux_aarch64` version should work on Mac OSX with Apple Silicon as well.
7. Verify installation.
 * `which qct`
 * `qct -h`

## Commands

```
# Shows help
qct -h
# Shows current version
qct -v
# Configures user settings. This is required before running `qct transform`
qct configure
# Runs a transformation. Both --source_version and --target_version are optional.
qct transform --source_folder=<path> --source_version <JAVA_1.8/JAVA_8/JAVA_11/JAVA_17/JAVA_21> --target_version=<JAVA_17/JAVA_21>
# Runs a transformation while vetting code to maintain security
qct transform --source_folder=<path> --target_version=<JAVA_17/JAVA_21> --trust 
# Runs a transformation in no-interactive mode
qct transform --source_folder=<path> --target_version=<JAVA_17/JAVA_21> --no-interactive
# Runs a transformation with a specified dependencies and versions to upgrade 
qct transform --source_folder=<path> --target_version=<JAVA_17/JAVA_21> --dependency_upgrade_file=<path-to-dependency-upgrade-yaml>
# Runs a SQL conversion transformation
qct transform --source_folder=<path> --sql_conversion_config_file=<path-to-sql-conversion-config-yaml>
```

## Stopping/Pausing a Transformation
You can pause or cancel the current transformation job by pressing Ctrl+C. Select pause and your transformation will be paused for up to 12 hours, run the same qct-transform command to resume later. Select cancel and your transformation will be stopped. 

## Configurations

To run `qct transform` successfully, first use the command `qct configure` to set OpenID Connect (OIDC) Identity Provider (IdP) directory start URL and JAVA_HOME configuration values. This will create/update `configuration.ini` file located in the `~/.aws/qcodetransform` directory.
```
java_8                                    # JAVA_HOME path for JDK 8 (if you are migrating Java 8 applications)
java_11                                   # JAVA_HOME path for JDK 11 (if you are migrating Java 11 applications)
java_17                                   # JAVA_HOME path for JDK 17, so that you can build the transformed code in your local machine.
java_21                                   # JAVA_HOME path for JDK 21, so that you can build the transformed code in your local machine.
directory_start_url                       # The IdP directory start url configured in your AWS IAM Identity Center (IdC) to use Q Developer.
tag_path                                  # CSV file path of tags for code transformations, each tag is represented as a key-value pair(eg:"key,value\nkey1,value1\nkey2,value2\n").
region                                    # AWS Region that hosts identity directory
telemetry_enabled                         # Enable telemetry in QCT CLI
```

**_Why is this needed?_**

Before transformation, we need to first build the project using the project's current java version (JDK 8/11/17/21). During / after transformation, we build the updated code using the  target (either JDK 17 or 21) version.

We need the different JAVA_HOME paths so that we can set JAVA_HOME correctly before running `mvn` commands.

Once the transformation completes, we restore JAVA_HOME to its original value.

## Project Artifacts
```
~/.aws/qccodetransform  # Directory created under user home to store all artifacts related to QCT
  credentials.json      # Stores client id, access, and refresh tokens for reuse.
  configurartions.ini   # Store user configuraitons.
  logs                  # All logs generated by QCT Client Library
  transformation_projects   # Main directory to store temporary artifacts for all transformaiton projects.
    <project_name>      # Top level project that is trasnformed.
                        # Contains all upload and download zip files.
                        # This is re-created for every transformation.
      initial_upload    # Initial upload of source and dependencies
      client_instructions_N     # Unzipped client instructions for iteration number: N
      transformation_results_N  # Unzipped final transformation results for iteration number: N
```

## Creating A Dependency Upgrade File

You can provide the QCT CLI with a dependency upgrade file, a YAML file that lists your project's dependencies and which versions to upgrade to during a transformation. By providing a dependency upgrade file, you can specify third and first party dependencies that Amazon Q might not otherwise know to upgrade.

For Amazon Q to upgrade any first party dependencies, you must specify them in the file. It can update third party dependencies that you don’t specify, but if there are any dependencies or versions you want to make sure it upgrades, add them to the file.

Amazon Q will prompt you to provide a dependency upgrade file during the transformation. If you want to provide one, first make sure you've configured the file properly. The following fields are required in the YAML file:

- name - The name of the dependency upgrade file.

- description (optional) - A description of the dependency upgrade file, and for which transformation.

- dependencyManagement - Contains the list of dependencies and plugins to upgrade.

- dependencies - Contains the name and version of the libraries to upgrade.

- plugins - Contains the names and versions of the plugins to upgrade.

- identifier - The name of the library, plugin, or other dependency.

- targetVersion - The version of the dependency to upgrade to.

- versionProperty (optional) - The version of the dependency you're defining, as set with the properties tag in your application's pom.xml file.

Following is an example of a dependency upgrade YAML file:
```yaml
name: dependency-upgrade
description: "Custom dependency version management for Java migration from JDK 8/11/17 to JDK 17/21"
dependencyManagement:
  dependencies:
    - identifier: "com.example:library1"
      targetVersion: "2.1.0"
      versionProperty: "library1.version"  # Optional
      originType: "FIRST_PARTY" # or "THIRD_PARTY"
    - identifier: "com.example:library2"
      targetVersion: "3.0.0"
      originType: "THIRD_PARTY"
  plugins:
    - identifier: "com.example.plugin"
      targetVersion: "1.2.0"
      versionProperty: "plugin.version"  # Optional
      originType: "THIRD_PARTY"
```
Please go through the [documentation on creating a dependency upgrade file](https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/run-CLI-transformations.html#step-3-dependency-upgrade-file) for details.

## SQL Conversion 
Before you begin, make you sure you've read [Converting embedded SQL in Java applications with Amazon Q Developer](https://docs.aws.amazon.com/amazonq/latest/qdeveloper-ug/transform-sql.html) to understand the prerequisites for this type of transformation.
To convert embedded SQL, you must first create a YAML file that contains the path to the schema metadata file from your AWS DMS Schema Conversion. 

Following is the required format of the file:
```yaml 
schema_conv_metadata_path: <path-to-metadata-zip-file>
```
Run the following command to start a transformation for a SQL conversion. Replace <path-to-folder> with the path to the folder with the code you're transforming and <path-to-sql-config-file> with the path to the YAML file you created earlier.

```
qct transform --source_folder <path-to-folder> --sql_conversion_config_file <path-to-sql-config-file>
```
If Amazon Q finds multiple schemas in your schema metadata file, it will stop the transformation and provide a list of the detected schemas. Choose which schema to use for the SQL conversion, and then add a new field `schema: <schema-name>` to the YAML file.
Amazon Q begins the transformation. It will output status updates throughout the transformation. When it’s complete, Amazon Q provides the path where the transformation results, logs, and configuration files are outputted.

Your upgraded code will be committed to the new branch Amazon Q created.